#ifndef _ENEMY_H
#define _ENEMY_H

#include "player.h"

#define STRAFELEFT  0
#define STRAFERIGHT 1
#define CURVELEFT   2
#define CURVERIGHT  3
#define SINELEFT    4
#define SINERIGHT   5
#define SINEDOWN    6
#define U_UP        7
#define U_DOWN      8

#define ECIRCLE   0
#define ESHIP     1
#define ESAUCER   2

typedef struct _enemy
{
	bool exists;
	short pattern, type, delay, shotdelay;
	float x, y, xv, yv, xa, ya, orig_y, orig_x;
	
	void do_stuff();
	void init(int type, int delay = 0);
	void init(int type, float x, float y, int pattern, int delay);
	void move();
	void draw();
	void fire();
	bool collided_with_player();
	bool was_shot();
} _enemy;

extern list<_shot> eshot;
extern list<_enemy> enemies;

void new_enemy(int type);
void new_enemy_group(int type, int num, int delay);
void do_enemies();

#endif
